from functools import partial
from typing import Optional, Tuple, Any
import Live
from .handler import GripHandler

class ViewHandler(GripHandler):
    def __init__(self, manager):
        super().__init__(manager)
        self.class_identifier = "view"

    def init_api(self):
        def get_selected_scene(params: Optional[Tuple] = ()):
            return (list(self.song.scenes).index(self.song.view.selected_scene),)

        def get_selected_track(params: Optional[Tuple] = ()):
            return (list(self.song.tracks).index(self.song.view.selected_track),)

        def get_selected_clip(params: Optional[Tuple] = ()):
            return (get_selected_track()[0], get_selected_scene()[0])
        
        def get_selected_device(params: Optional[Tuple] = ()):
            return (get_selected_track()[0], list(self.song.view.selected_track.devices).index(self.song.view.selected_track.view.selected_device))

        def set_selected_scene(params: Optional[Tuple] = ()):
            self.song.view.selected_scene = self.song.scenes[params[0]]

        def set_selected_track(params: Optional[Tuple] = ()):
            self.song.view.selected_track = self.song.tracks[params[0]]

        def set_selected_clip(params: Optional[Tuple] = ()):
            set_selected_track((params[0],))
            set_selected_scene((params[1],))

        def set_selected_device(params: Optional[Tuple] = ()):
            device = self.song.tracks[params[0]].devices[params[1]]
            self.song.view.select_device(device)
            return params[0], params[1]

        self.osc_server.add_handler("/live/view/get/selected_scene", get_selected_scene)
        self.osc_server.add_handler("/live/view/get/selected_track", get_selected_track)
        self.osc_server.add_handler("/live/view/get/selected_clip", get_selected_clip)
        self.osc_server.add_handler("/live/view/get/selected_device", get_selected_device)
        self.osc_server.add_handler("/live/view/set/selected_scene", set_selected_scene)
        self.osc_server.add_handler("/live/view/set/selected_track", set_selected_track)
        self.osc_server.add_handler("/live/view/set/selected_clip", set_selected_clip)
        self.osc_server.add_handler("/live/view/set/selected_device", set_selected_device)
        
        self.osc_server.add_handler('/live/view/start_listen/selected_scene', partial(self._start_listen, self.song.view, "selected_scene", getter=get_selected_scene))
        self.osc_server.add_handler('/live/view/start_listen/selected_track', partial(self._start_listen, self.song.view, "selected_track", getter=get_selected_track))
        self.osc_server.add_handler('/live/view/stop_listen/selected_scene', partial(self._stop_listen, self.song.view, "selected_scene"))
        self.osc_server.add_handler('/live/view/stop_listen/selected_track', partial(self._stop_listen, self.song.view, "selected_track"))

        # Application view (different from song.view)
        # Must get app_view fresh for listener registration, but getter fetches live each call
        def get_focused_document_view(params=None):
            # Returns 'Session' or 'Arranger'
            app_view = Live.Application.get_application().view
            return (app_view.focused_document_view,)

        def set_focused_document_view(params: Optional[Tuple] = ()):
            # Accepts 'Session' or 'Arranger'
            if params and len(params) > 0:
                view_name = params[0]
                app_view = Live.Application.get_application().view
                app_view.focus_view(view_name)

        # For listeners, we need the actual view object reference
        app_view = Live.Application.get_application().view
        self.osc_server.add_handler("/live/view/get/focused_document_view", get_focused_document_view)
        self.osc_server.add_handler("/live/view/set/focused_document_view", set_focused_document_view)
        self.osc_server.add_handler('/live/view/start_listen/focused_document_view', partial(self._start_listen, app_view, "focused_document_view", getter=get_focused_document_view))
        self.osc_server.add_handler('/live/view/stop_listen/focused_document_view', partial(self._stop_listen, app_view, "focused_document_view"))
