# Grip Remote Script

The Grip remote script is an Open Sound Control (OSC) interface for Ableton Live.

## About

The Grip remote script provides comprehensive control over Ableton Live's control interfaces using the [Live Object Model](https://docs.cycling74.com/max8/vignettes/live_object_model) API via OSC.

**The Grip remote script is included as part of the Grip software product**, which is sold commercially. This remote script is automatically installed when users install Grip, enabling zero-configuration OSC communication between the Grip daemon and Ableton Live.

## License

The Grip remote script is based on work by Daniel Jones (ideoforms), licensed under the MIT License. See [LICENSE.md](./LICENSE.md) for full details.

## Grip-Specific Modifications

See [GRIP-CHANGES.md](./GRIP-CHANGES.md) for a complete list of modifications made to the original codebase.

## Technical Details

### OSC Ports

The Grip remote script uses dedicated ports:

| Mode | Listen Port | Response Port |
|------|-------------|---------------|
| Production | 47140 | 47141 |
| Development | 47240 | 47241 |

**Dual-daemon support:** The remote script listens on ALL ports simultaneously, allowing both production and development Grip daemons to communicate with Ableton at the same time.

### Generated Configuration

**`live/constants.py` is auto-generated** from `apps/grip/config.json` during the build process.

To change port values:
1. Edit `apps/grip/config.json` (the single source of truth)
2. Run `yarn build` (or `yarn workspace @grip/remote-script build`)
3. The generated `constants.py` will be in `build/Grip/live/`

See `live/constants.py.template` for reference.

### API Documentation

For detailed API documentation, see [README-ABLETONOSC.md](../../docs/README-ABLETONOSC.md) in the docs folder.

---

**Note:** The Grip remote script requires Ableton Live 11 or above.
